<?php

namespace App\Http\Controllers;

use App\Models\Guru;
use App\Models\Kelas;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Storage;
use RealRashid\SweetAlert\Facades\Alert;

class GuruController extends Controller
{
    public function index()
    {
        $gurus = Guru::all();
        $kelas = Kelas::all();
        return view('guru.index', compact('gurus', 'kelas'));
    }

    public function frontIndex()
    {
        $gurus = Guru::all();
        return view('pages.guru', compact('gurus'));
    }

    public function store(Request $request)
    {
        try {
            $request->validate([
                'nama' => 'required',
                'kelas_id' => 'required',
                'nip' => 'required',
                'jenis_kelamin' => 'required',
                'alamat' => 'required',
                'no_hp' => 'required',
                'foto' => 'required'
            ]);

            $data = $request->all();
            // add photo dengan value yang tersimpan $data['foto] path+filename
            if ($request->hasFile('foto')) {
                $file = $request->file('foto');
                $filename = time() . '.' . $file->getClientOriginalExtension();
                $file->storeAs('public/guru', $filename);
                $data['foto'] = 'guru/'. $filename;
            }

            Guru::create($data);
            Alert::success('Success', 'Data guru berhasil ditambahkan');
            return redirect()->route('guru.index');
        } catch (\Exception $e) {
            Alert::error('Error', 'Data guru gagal ditambahkan');
            return redirect()->route('guru.index');
        }
    }

    public function update(Request $request, $id) : RedirectResponse
    {
        try {
            $data = $request->all();
            $guru = Guru::where('id', $id)->first();
            $pathfoto = $guru->foto;

            if ($request->hasFile('foto')) {
                if ($pathfoto) {
                    Storage::disk('public')->delete($pathfoto);
                }

                $file = $request->file('foto');
                $filename = time() . '.' . $file->getClientOriginalExtension();
                $file->storeAs('public/guru', $filename);
                $data['foto'] = 'guru/' . $filename;  // Removed 'storage/' prefix
            } else {
                unset($data['foto']);
            }

            $guru->update($data);
            Alert::success('Success', 'Data guru berhasil diubah');
            return redirect()->route('guru.index');
        } catch (\Exception $e) {
            Alert::error('Error', 'Data guru gagal diubah');
            return redirect()->route('guru.index');
        }
    }

    public function destroy($id)
    {
        try {
            $guru = Guru::where('id', $id)->first();
            $pathfoto = $guru->foto;

            if ($pathfoto) {
                Storage::disk('public')->delete($pathfoto);
            }

            $guru->delete();
            Alert::success('Success', 'Data guru berhasil dihapus');
            return redirect()->route('guru.index');
        } catch (\Exception $e) {
            Alert::error('Error', 'Data guru gagal dihapus');
            return redirect()->route('guru.index');
        }
    }
}
