<?php

namespace App\Http\Controllers;

use App\Models\Informasi;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Storage;
use RealRashid\SweetAlert\Facades\Alert;

class InformasiController extends Controller
{
    public function index()
    {
        $informasis = Informasi::latest()->get();

        return view('informasi.index', compact('informasis'));
    }

    public function frontIndex()
    {
        $informasis = Informasi::published()->latest()->paginate(10);

        return view('pages.informasi', compact('informasis'));
    }

    public function create()
    {
        return view('informasi.add-informasi');
    }

    public function store(Request $request)
    {
        try {
            $request->validate([
                'judul' => 'required',
                'deskripsi' => 'required',
                'gambar' => 'required',
                'status' => 'required',
                'kategori' => 'required',
            ]);

            $data = $request->all();
            $data['slug'] = \Str::slug($request->judul);

            if ($request->hasFile('gambar')) {
                $file = $request->file('gambar');
                $filename = time() . '.' . $file->getClientOriginalExtension();
                $file->storeAs('public/informasi', $filename);
                $data['gambar'] = 'informasi/' . $filename;
            }

            Informasi::create($data);
            Alert::success('Success', 'Data informasi berhasil ditambahkan');
            return redirect()->route('informasi.index');
        } catch(\Exception $e) {
            Alert::error('Error', 'Data informasi gagal ditambahkan');
            return redirect()->route('informasi.index');
        }
    }

    public function show(Informasi $informasi)
    {
        $infromasi = Informasi::where('slug', $informasi->slug)->first();

        return view('informasi.show-informasi', compact('informasi'));
    }

    public function edit(Informasi $informasi)
    {
        $data = Informasi::where('slug', $informasi->slug)->first();

        return view('informasi.edit-informasi', compact('data'));
    }

    public function update(Request $request, $id) : RedirectResponse
    {
        try {
            $data = $request->all();
            $informasi = Informasi::where('id', $id)->first();
            $pathGambar = $informasi->gambar;
            $data['slug'] = \Str::slug($request->judul);

            if ($request->hasFile('gambar')) {
                if ($pathGambar) {
                    Storage::disk('public')->delete($pathGambar);
                }

                $file = $request->file('gambar');
                $filename = time() . '.' . $file->getClientOriginalExtension();
                $file->storeAs('public/informasi', $filename);
                $data['gambar'] = 'informasi/' . $filename;
            }

            $informasi->update($data);
            Alert::success('Success', 'Data informasi berhasil diubah');
            return redirect()->route('informasi.index');
        } catch(\Exception $e) {
            Alert::error('Error', 'Data informasi gagal diubah');
            return redirect()->route('informasi.index');
        }
    }

    public function destroy($id)
    {
        try {
            $informasi = Informasi::findOrFail($id);
            $pathGambar = $informasi->gambar;

            if ($pathGambar) {
                Storage::disk('public')->delete($pathGambar);
            }

            $informasi->delete();
            Alert::success('Success', 'Data informasi berhasil dihapus');
            return redirect()->route('informasi.index');
        } catch(\Exception $e) {
            Alert::error('Error', 'Data informasi gagal dihapus');
            return redirect()->route('informasi.index');
        }
    }
}
