<?php

namespace App\Http\Controllers;

use App\Models\Kelas;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use RealRashid\SweetAlert\Facades\Alert;

class KelasController extends Controller
{
    public function index()
    {
        $kelas = Kelas::all();
        return view('kelas.index', compact('kelas'));
    }

    public function store(Request $request)
    {
        try{
            $data = $request->all();
            Kelas::create($data);

            Alert::success('Success', 'Kelas berhasil ditambahkan');
            return redirect()->route('kelas.index');
        } catch (\Exception $e) {
            Alert::error('Error', 'Kelas gagal ditambahkan');
            return redirect()->route('kelas.index');
        }
    }

    public function update(Request $request, $id): RedirectResponse
    {
        try {
            $data = $request->all();
            $kelas = Kelas::find($id);
            $kelas->update($data);

            Alert::success('Success', 'Kelas berhasil diupdate');
            return redirect()->route('kelas.index');
        } catch (\Exception $e) {
            Alert::error('Error', 'Kelas gagal diupdate');
            return redirect()->route('kelas.index');
        }
    }

    public function destroy($id): RedirectResponse
    {
        try {
            $kelas = Kelas::find($id);
            $kelas->delete();
            Alert::success('Success', 'Kelas berhasil dihapus');
            return redirect()->route('kelas.index');
        } catch (\Exception $e) {
            Alert::error('Error', 'Kelas gagal dihapus');
            return redirect()->route('kelas.index');
        }
    }
}
