<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Informasi extends Model
{
    use HasFactory;

    protected $fillable = [
        'judul',
        'deskripsi',
        'gambar',
        'slug',
        'status',
        'kategori',
    ];

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function scopePublished($query)
    {
        return $query->where('status', 'PUBLISH');
    }

    public function scopeDraft($query)
    {
        return $query->where('status', 'DRAFT');
    }

    public function scopeBerita($query)
    {
        return $query->where('kategori', 'BERITA');
    }

    public function scopeArtikel($query)
    {
        return $query->where('kategori', 'ARTIKEL');
    }

    public function scopeKegiatan($query)
    {
        return $query->where('kategori', 'KEGIATAN');
    }

    public function scopeAkademik($query)
    {
        return $query->where('kategori', 'AKADEMIK');
    }

    public function scopeNonAkademik($query)
    {
        return $query->where('kategori', 'NON-AKADEMIK');
    }

    public function setSlugAttribute($value)
    {
        $this->attributes['slug'] = \Str::slug($value);
    }

}
