<x-guest-layout>
    <div class="flex items-center justify-center bg-gray-100 dark:bg-gray-900 md:flex-col">
        <!-- Wrapper Container -->
        <div class="flex flex-row w-full max-w-6xl bg-white dark:bg-gray-800 shadow-md rounded-lg overflow-hidden">

            <!-- Gambar di kiri -->
            <div class="w-1/2 hidden md:block">
                <img src="{{ asset('images/vector-register.png') }}" alt="Login Illustration" class="w-full h-full object-cover">
            </div>

            <!-- Form Login di kanan -->
            <div class="w-full lg:p-8 md:w-1/2 p-2 flex flex-col justify-center">
                {{-- Header --}}
                <h1 class="text-4xl font-extrabold text-center text-gray-900 dark:text-gray-100">MI AL-AMIEN</h1>
                <h3 class="mb-6 text-1xl font-extrabold text-center text-gray-900 dark:text-gray-100">
                    {{ __('Silahkan Register Account untuk Siswa Baru') }}
                </h2>

                <form method="POST" action="{{ route('register') }}">
                    @csrf

                    <!-- Name -->
                    <div>
                        <x-input-label for="name" :value="__('Nama Lengkap')" />
                        <x-text-input id="name" class="block mt-1 w-full" type="text" name="name" :value="old('name')" required autofocus autocomplete="name" />
                        <x-input-error :messages="$errors->get('name')" class="mt-2" />
                    </div>

                    <!-- Email Address -->
                    <div class="mt-4">
                        <x-input-label for="email" :value="__('Email')" />
                        <x-text-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required autocomplete="username" />
                        <x-input-error :messages="$errors->get('email')" class="mt-2" />
                    </div>

                    <!-- Password -->
                    <div class="mt-4">
                        <x-input-label for="password" :value="__('Kata Sandi')" />

                        <x-text-input id="password" class="block mt-1 w-full"
                                        type="password"
                                        name="password"
                                        required autocomplete="new-password" />

                        <x-input-error :messages="$errors->get('password')" class="mt-2" />
                    </div>

                    <!-- Confirm Password -->
                    <div class="mt-4">
                        <x-input-label for="password_confirmation" :value="__('Ulangi Kata Sandi')" />

                        <x-text-input id="password_confirmation" class="block mt-1 w-full"
                                        type="password"
                                        name="password_confirmation" required autocomplete="new-password" />

                        <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
                    </div>

                    <div class="flex items-center justify-end mt-4">
                        <a class="underline text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-gray-800" href="{{ route('login') }}">
                            {{ __('Sudah punya akun ?') }}
                        </a>

                        <x-primary-button class="ms-4">
                            {{ __('Daftar') }}
                        </x-primary-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-guest-layout>
