@props(['href', 'title', 'icon', 'text'])

<a href="{{ $href }}" class="card-hover flex items-start gap-4 rounded-lg bg-white p-6 shadow-md border border-gray-200 transition hover:shadow-xl dark:bg-zinc-900 dark:border-zinc-700">
    <div class="flex size-12 items-center justify-center rounded-full bg-[#FF2D20]/10 text-[#FF2D20]">
        <i class="{{ $icon }} text-xl"></i>
    </div>
    <div class="flex flex-col">
        <h3 class="text-lg font-semibold text-black dark:text-white">{{ $title }}</h3>
        <p class="mt-1 text-sm text-gray-600 dark:text-gray-300">{{ $text }}</p>
    </div>
</a>
