<section>
    <header>
        <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
            {{ __('List Guru') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
            {{ __("Kelola Data Guru") }}
        </p>
    </header>
    <div class="container mx-auto mt-6">
        <x-table :headers="['No','Foto','Nama Guru', 'Kelas', 'Aksi']">
            @foreach ($gurus as $item)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900">{{ $loop->iteration }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="flex items center">
                            <div class="flex-shrink-0">
                                <img class="w-20 rounded-full" src="/storage/{{ $item->foto }}" alt="">
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium text-gray-900">{{ $item->nama }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900">{{ $item->kelas->nama_kelas }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium">
                        <button onclick="editGuru('{{ $item->id }}', '{{ $item->nama }}', '{{ $item->kelas_id }}', '{{ $item->nip }}', '{{ $item->jenis_kelamin }}', '{{ $item->alamat }}', '{{ $item->no_hp }}', '{{ $item->foto }}' )" class="text-indigo-600 hover:text-indigo-900">Edit</button>
                        <form action="{{ route('guru.destroy', $item->id) }}" method="post" class="inline-block">
                            @csrf
                            @method('delete')
                            <button type="submit" onclick="return confirm('Apakah yakin ingin dihapus?')" class="text-red-600 hover:text-red-900">Delete</button>
                        </form>
                    </td>
                    </td>
                </tr>
            @endforeach
        </x-table>
    </div>
</section>

<script>
    function editGuru(id, namaGuru, kelas, nip, jenisKelamin, alamat, noHp, foto) {
        document.getElementById('guru-id').value = id;
        document.getElementById('nama').value = namaGuru;
        document.getElementById('kelas').value = kelas;
        document.getElementById('nip').value = nip;
        document.getElementById('jenis_kelamin').value = jenisKelamin;
        document.getElementById('alamat').value = alamat;
        document.getElementById('no_hp').value = noHp;
        document.getElementById('preview-foto').src = '/storage/'+foto;
        document.getElementById('form-title').innerText = 'Edit Guru';
        document.getElementById('form-button').innerText = 'Perbarui';

        document.getElementById('guru-form').action = '{{ route('guru.update', '') }}' + '/' + id;
        let methodInput = document.createElement('input');
        methodInput.setAttribute('type', 'hidden');
        methodInput.setAttribute('name', '_method');
        methodInput.setAttribute('value', 'PATCH');
        document.getElementById('guru-form').appendChild(methodInput);

    }
</script>
