<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Form Informasi') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="p-4 sm:p-8 bg-white dark:bg-gray-800 shadow sm:rounded-lg">
                <div class="max-w-12xl">
                    <section>
                        <form id="informasi-form" method="POST" action="{{ route('informasi.store') }}" enctype="multipart/form-data">
                            @csrf
                            @include('informasi.partials.form-informasi')
                        </form>

                        <script>
                            document.getElementById('gambar').addEventListener('change', function(event) {
                                var file = event.target.files[0];
                                var reader = new FileReader();

                                reader.onload = function(e) {
                                    document.getElementById('preview-foto').src = e.target.result;
                                    document.getElementById('preview-foto').style.height = '300px';
                                };

                                reader.readAsDataURL(file);
                            });
                        </script>
                    </section>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
