<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Edit Informasi') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="p-4 sm:p-8 bg-white dark:bg-gray-800 shadow sm:rounded-lg">
                <div class="max-w-12xl">
                    <section>
                        <form id="informasi-form" method="POST" action="{{ route('informasi.update', $data->id) }}" enctype="multipart/form-data">
                            @csrf
                            @method('PATCH')
                            <div class="space-y-6">
                                <header>
                                    <a href="{{ route('informasi.index') }}" class="text-blue-500 hover:text-blue-700">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 inline-block" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                                            </path>
                                        </svg> Batal
                                    </a>
                                    <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100 mt-2">
                                        {{ __('Upload Gambar') }}
                                    </h2>

                                    <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                                        {{ __("Upload Gambar.") }}
                                    </p>
                                </header>
                                {{-- Upload Photo --}}
                                <div>
                                    <x-input-label for="gambar" :value="__('Gambar')" />
                                    <x-file-input id="gambar" name="gambar" class="mt-1 block w-full" />
                                    <x-input-error class="mt-2" :messages="$errors->get('gambar')" />
                                </div>

                                <div class="mt-4">
                                    <img id="preview-foto" src="{{ asset('storage/'. $data->gambar) }}" alt=" Foto Profil" class="w-max h-52 text-gray-300 rounded-lg">
                                </div>

                                {{-- Garis Horizontal --}}
                                <hr class="my-8">
                                {{-- Judul --}}
                                <div>
                                    <x-input-label for="judul" :value="__('Judul')" />
                                    <x-text-input id="judul" name="judul" type="text" :value="old('judul', $data->judul)" class="mt-1 block w-full" required autofocus autocomplete="judul" />
                                    <x-input-error class="mt-2" :messages="$errors->get('judul')" />
                                </div>

                                {{-- Deskripsi --}}
                                <div>
                                    <x-input-label for="deskripsi" :value="__('Deskripsi')" />
                                    <textarea id="deskripsi" name="deskripsi" class="mt-1 block w-full" required>{{ old('deskripsi', $data->deskripsi)}}</textarea>
                                    <x-input-error class="mt-2" :messages="$errors->get('deskripsi')" />
                                </div>

                                {{-- Kategori --}}
                                <div>
                                    <x-input-label for="kategori" :value="__('Kategori')" />
                                    <select id="kategori" name="kategori" class="mt-1 block w-full" required>
                                        <option value="">Pilih Kategori</option>
                                        <option value="ARTIKEL" {{ old('kategori', $data->kategori) === 'ARTIKEL' ? 'selected' : '' }}>Artikel</option>
                                        <option value="BERITA" {{ old('kategori', $data->kategori) === 'BERITA' ? 'selected' : '' }}>Berita</option>
                                        <option value="KEGIATAN" {{ old('kategori', $data->kategori) === 'KEGIATAN' ? 'selected' : '' }}>Kegiatan</option>
                                        <option value="AKADEMIK" {{ old('kategori', $data->kategori) === 'AKADEMIK' ? 'selected' : '' }}>Akademik</option>
                                        <option value="NON-AKADEMIK" {{ old('kategori', $data->kategori) === 'NON-AKADEMIK' ? 'selected' : '' }}>Non Akademik</option>
                                    </select>
                                    <x-input-error class="mt-2" :messages="$errors->get('kategori')" />
                                </div>

                                {{-- Status --}}
                                <div>
                                    <x-input-label for="status" :value="__('Status')" />
                                    <select id="status" name="status" class="mt-1 block w-full" required>
                                        <option value="">Pilih Status</option>
                                        <option value="PUBLISH" {{ old('status', $data->status) === 'PUBLISH' ? 'selected' : '' }}>Publish</option>
                                        <option value="DRAFT" {{ old('status', $data->status) === 'DRAFT' ? 'selected' : '' }}>Draft</option>
                                    </select>
                                    <x-input-error class="mt-2" :messages="$errors->get('status')" />
                                </div>
                            </div>

                            <div class="flex items-center gap-4 mt-6 space-y-6">
                                <x-primary-button id="form-button">{{ __('Simpan') }}</x-primary-button>
                                {{-- Tombol Batal --}}
                            </div>

                        </form>

                        <script>
                            document.getElementById('gambar').addEventListener('change', function(event) {
                                var file = event.target.files[0];
                                var reader = new FileReader();

                                reader.onload = function(e) {
                                    document.getElementById('preview-foto').src = e.target.result;
                                    document.getElementById('preview-foto').style.height = '300px';
                                };

                                reader.readAsDataURL(file);
                            });
                        </script>
                    </section>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
