<section>
    <header>
        <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
            {{ __('Informasi') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
            {{ __("Kelola Data Informasi") }}
        </p>

        {{-- Tombol Tambah Data dibagian ujung kanan --}}
        <div class="flex justify-end">
            <a href="{{ route('informasi.create') }}" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded mt-4">
                + Tambah Informasi
            </a>
        </div>
    </header>
    <div class="container mx-auto mt-6">
        <x-table :headers="['No','Gambar','Judul', 'Kategori', 'Status', 'Aksi']">
            @foreach ($informasis as $item)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900">{{ $loop->iteration }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="flex items center">
                            <div class="flex-shrink-0">
                                <img class="w-20" src="{{ asset('storage/'. $item->gambar) }}" alt="">
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium text-gray-900">{{ $item->judul }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900">{{ $item->kategori }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 inline-flex text-sm leading-5 font-semibold rounded-full {{ $item->status == 'PUBLISH' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }} ">
                            {{ $item->status }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium">
                        <a href="{{ route('informasi.edit', ['informasi' => $item->slug]) }}" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                        <form action="{{ route('informasi.destroy', $item->id) }}" method="post" class="inline-block">
                            @csrf
                            @method('delete')
                            <button type="submit" onclick="return confirm('Apakah yakin ingin dihapus?')" class="text-red-600 hover:text-red-900">Delete</button>
                        </form>
                    </td>
                    </td>
                </tr>
            @endforeach
        </x-table>
    </div>
</section>
