<section>
    <header>
        <h2 id="form-title" class="text-lg font-medium text-gray-900 dark:text-gray-100">
            {{ __('Tambah Kelas') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
            {{ __("Kelola Daftar Kelas") }}
        </p>
    </header>

    <form id="kelas-form" method="POST" action="{{ route('kelas.store') }}" class="mt-6 space-y-6">
        @csrf
        <input type="hidden" id="kelas-id" name="kelas_id" value="">
        <div>
            <x-input-label for="nama_kelas" :value="__('Nama Kelas')" />
            <x-text-input id="nama_kelas" name="nama_kelas" type="text" class="mt-1 block w-full" required autofocus autocomplete="nama_kelas" />
            <x-input-error class="mt-2" :messages="$errors->get('nama_kelas')" />
        </div>

        <div class="flex items-center gap-4">
            <x-primary-button id="form-button">{{ __('Tambah') }}</x-primary-button>

            @if (session('status') === 'Kelas-Ditambahkan')
                <p
                    x-data="{ show: true }"
                    x-show="show"
                    x-transition
                    x-init="setTimeout(() => show = false, 2000)"
                    class="text-sm text-gray-600 dark:text-gray-400"
                >{{ __('Saved.') }}</p>
            @endif
        </div>
    </form>
</section>
