<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __(' Edit Pendaftaran') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            <div class="p-4 sm:p-8 bg-white dark:bg-gray-800 shadow sm:rounded-lg">
                <div class="max-w-12xl">
                    <form method="POST" action="{{ route('pendaftaran.update', $data->id) }}" enctype="multipart/form-data">
                        @csrf
                        {{-- method PATCH --}}
                        @method('PATCH')
                        {{-- Upload Photo --}}
                        <div class="mt-6 space-y-6">
                            <x-input-label for="pas_photo" :value="__('Photo')" />
                            <x-file-input id="pas_photo" name="pas_photo" class="mt-1 block w-full" autocomplete="pas_photo" />
                            <x-input-error class="mt-2" :messages="$errors->get('pas_photo')" />
                        </div>

                        <div class="mt-4">
                            <img id="preview-foto" src="{{ asset('storage/' . $data->pas_photo) }}" alt=" Foto Profil" class="h-80 text-gray-300 rounded-lg">
                        </div>
                        {{-- Gari Horizontal --}}
                        <div class="border-t border-gray-900 dark:border-gray-100 mt-4 mb-4"></div>
                        {{-- Form Pendaftaran --}}
                        <section>
                            <header>
                                <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
                                    <i class="mdi mdi-numeric-2-circle"></i>
                                    {{ __('Form Pendaftaran') }}
                                </h2>

                                <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                                    {{ __("Lengkapi Forms Pendaftaran dibawah ini sesuai dengan data diri siswa.") }}
                                </p>
                            </header>

                            <div class="mt-6 space-y-6">
                                {{-- NIK --}}
                                <div>
                                    <x-input-label for="nik" :value="__('NIK')" />
                                    <x-text-input id="nik" name="nik" type="text" :value="old('nik', $data->nik)" class="mt-1 block w-full" required
                                        autocomplete="nik" />
                                    <x-input-error class="mt-2" :messages="$errors->get('nik')" />
                                </div>

                                {{-- Nama Lengkap --}}
                                <div>
                                    <x-input-label for="nama" :value="__('Nama Lengkap')" />
                                    <x-text-input id="nama" name="nama" type="text" :value="old('nama', $data->nama)" class="mt-1 block w-full" required
                                        autocomplete="nama" />
                                    <x-input-error class="mt-2" :messages="$errors->get('nama')" />
                                </div>

                                {{-- Jenis Kelamin --}}
                                <div>
                                    <x-input-label for="jenis_kelamin" :value="__('Jenis Kelamin')" />
                                    <select id="jenis_kelamin" name="jenis_kelamin"
                                            class="mt-1 block w-full rounded-md shadow-sm border-gray-300
                                                   focus:border-primary-300 focus:ring focus:ring-primary-200
                                                   focus:ring-opacity-50 dark:bg-gray-700 dark:text-gray-300
                                                   dark:border-gray-600 dark:focus:border-primary-600"
                                            required>
                                        <option value="">Pilih Jenis Kelamin</option>
                                        <option value="Laki-laki" {{ old('jenis_kelamin', $data->jenis_kelamin) === 'Laki-laki' ? 'selected' : '' }}>Laki-laki</option>
                                        <option value="Perempuan" {{ old('jenis_kelamin', $data->jenis_kelamin) === 'Perempuan' ? 'selected' : '' }}>Perempuan</option>
                                    </select>
                                    <x-input-error class="mt-2" :messages="$errors->get('jenis_kelamin')" />
                                </div>

                                {{-- Tempat Lahir --}}
                                <div>
                                    <x-input-label for="tempat_lahir" :value="__('Tempat Lahir')" />
                                    <x-text-input id="tempat_lahir" name="tempat_lahir" :value="old('tempat_lahir', $data->tempat_lahir)" type="text" class="mt-1 block w-full" required
                                        autocomplete="tempat_lahir" />
                                    <x-input-error class="mt-2" :messages="$errors->get('tempat_lahir')" />
                                </div>

                                {{-- Tanggal Lahir --}}
                                <div>
                                    <x-input-label for="tanggal_lahir" :value="__('Tanggal Lahir')" />
                                    <x-text-input id="tanggal_lahir" name="tanggal_lahir" type="date" :value="old('tanggal_lahir', $data->tanggal_lahir)" class="mt-1 block w-full" required
                                        autocomplete="tanggal_lahir" placeholder="yyyy/mm/dd" pattern="\d{4}/\d{2}/\d{2}" />
                                    <x-input-error class="mt-2" :messages="$errors->get('tanggal_lahir')" />
                                </div>

                                {{-- Alamat --}}
                                <div>
                                    <x-input-label for="alamat" :value="__('Alamat')" />
                                    <x-text-input id="alamat" name="alamat" type="text" :value="old('alamat', $data->alamat)" class="mt-1 block w-full" required
                                        autocomplete="alamat" />
                                    <x-input-error class="mt-2" :messages="$errors->get('alamat')" />
                                </div>

                                {{-- No Telpon Orang Tua --}}
                                <div>
                                    <x-input-label for="no_hp" :value="__('No Telpon Orang Tua')" />
                                    <x-text-input id="no_hp" name="no_hp" type="text" :value="old('no_hp', $data->no_hp)" class="mt-1 block w-full" required autofocus
                                        autocomplete="no_hp" />
                                    <x-input-error class="mt-2" :messages="$errors->get('no_hp')" />
                                </div>

                                {{-- Status --}}
                                <div>
                                    <x-input-label for="status" :value="__('Status')" />
                                    <select id="status" name="status" :value="old('status', $data->status)" class="mt-1 block w-full rounded-md shadow-sm border-gray-300 focus:border-primary-300 focus:ring focus:ring-primary-200 focus:ring-opacity-50 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-600 dark:focus:border-primary-600" required>
                                        <option value="">Pilih Status</option>
                                        <option value="pending" {{ old('status', $data->status) === 'pending' ? 'selected' : '' }}>Menunggu Diperiksa</option>
                                        <option value="approved" {{ old('status', $data->status) === 'approved' ? 'selected' : '' }}>Diterima</option>
                                        <option value="rejected" {{ old('status', $data->status) === 'rejected' ? 'selected' : ''}}>Ditolak</option>
                                    </select>
                                    <x-input-error class="mt-2" :messages="$errors->get('status')" />
                                </div>

                                <div class="flex items-center gap-4">
                                    <x-primary-button>{{ __('Simpan') }}</x-primary-button>
                                    @if (session('status') === 'Pendaftaraan-Sukses')
                                        <p x-data="{ show: true }" x-show="show" x-transition x-init="setTimeout(() => show = false, 2000)"
                                            class="text-sm text-gray-600 dark:text-gray-400">{{ __('Saved.') }}
                                        </p>
                                    @endif
                                </div>
                            </div>
                        </section>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.getElementById('pas_photo').addEventListener('change', function(event) {
            var file = event.target.files[0];
            var reader = new FileReader();

            reader.onload = function(e) {
                document.getElementById('preview-foto').src = e.target.result;
                document.getElementById('preview-foto').style.height = '400px';
            };

            reader.readAsDataURL(file);
        });
    </script>
</x-app-layout>
