<section>
    <header>
        <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
            {{ __('List Pendaftaran') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
            {{ __("Kelola Pendaftaran") }}
        </p>
    </header>
    <div class="container mx-auto mt-6">
        <x-table :headers="['No','Nama', 'NIK', 'Jenis Kelamin', 'Status', 'Aksi']">
            @foreach ($pendaftaran as $item)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900">{{ $loop->iteration }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium text-gray-900">{{ $item->nama }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900">{{ $item->nik }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900">{{ $item->jenis_kelamin }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        @if ($item->status == 'pending')
                            <div class="text-sm text-blue-500">Sedang Diproses</div>
                        @elseif ($item->status == 'approved')
                            <div class="text-sm text-green-500">Diterima</div>
                        @elseif ($item->status == 'rejected')
                            <div class="text-sm text-red-500">Ditolak</div>
                        @else
                            <div class="text-sm text-red-500">Belum Mendaftar</div>
                        @endif
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium">
                        <a href="{{ route('pendaftaran.edit', ['pendaftaran' => $item->id]) }}" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                        <form action="{{ route('kelas.destroy', $item->id) }}" method="post" class="inline-block">
                            @csrf
                            @method('delete')
                            <button type="submit" onclick="return confirm('Apakah yakin ingin dihapus?')" class="text-red-600 hover:text-red-900">Delete</button>
                        </form>
                    </td>
                    </td>
                </tr>
            @endforeach
        </x-table>
    </div>
</section>
