<section>
    <header>
        <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
            <i class="mdi mdi-numeric-1-circle"></i>
            {{ __('Upload Photo') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
            {{ __("Upload foto diri siswa.") }}
        </p>
    </header>

    <div class="mt-6 space-y-6">
        <x-input-label for="pas_photo" :value="__('Photo')" />
        <x-file-input id="pas_photo" name="pas_photo" class="mt-1 block w-full" required autocomplete="pas_photo" />
        <x-input-error class="mt-2" :messages="$errors->get('pas_photo')" />
    </div>

    <div class="mt-4">
        <img id="preview-foto" src="" alt="Foto Profil" class="h-10 text-gray-300 rounded-lg hidden">
    </div>

    <script>
        document.getElementById('pas_photo').addEventListener('change', function(event) {
            var file = event.target.files[0];
            var preview = document.getElementById('preview-foto');

            if (file) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.classList.remove('hidden');
                    preview.style.height = '400px';
                };
                reader.readAsDataURL(file);
            } else {
                preview.src = '';
                preview.classList.add('hidden');
            }
        });
    </script>
</section>
