<section>
    <header>
        <h2 id="form-title" class="text-lg font-medium text-gray-900 dark:text-gray-100">
            {{ __('Tambah Pengguna') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
            {{ __("Kelola Daftar Pengguna") }}
        </p>
    </header>

    <form id="pengguna-form" method="POST" action="{{ route('pengguna.store') }}" class="mt-6 space-y-6">
        @csrf
        <input type="hidden" id="pengguna-id" name="pengguna_id" value="">
        <div>
            <x-input-label for="name" :value="__('Nama Lengkap')" />
            <x-text-input id="name" name="name" type="text" class="mt-1 block w-full" autofocus autocomplete="name" />
            <x-input-error class="mt-2" :messages="$errors->get('name')" />
        </div>
        {{-- Email --}}
        <div>
            <x-input-label for="email" :value="__('Email')" />
            <x-text-input id="email" name="email" type="email" class="mt-1 block w-full" />
            <x-input-error class="mt-2" :messages="$errors->get('email')" />
        </div>
        {{-- password --}}
        <div>
            <x-input-label for="password" :value="__('Password')" />
            <x-text-input id="password" name="password" type="password" class="mt-1 block w-full" />
            <x-input-error class="mt-2" :messages="$errors->get('password')" />
        </div>
        {{-- Role --}}
        <div>
            <x-input-label for="role" :value="__('Role')" />
            <select id="role" name="role" class="mt-1 block w-full">
                <option value="">Pilih Role</option>
                <option value="admin">Admin</option>
                <option value="siswa">Siswa</option>
            </select>
            <x-input-error class="mt-2" :messages="$errors->get('role')" />
        </div>

        <div class="flex items-center gap-4">
            <x-primary-button id="form-button">{{ __('Tambah') }}</x-primary-button>

            @if (session('status') === 'Pengguna-Ditambahkan')
                <p
                    x-data="{ show: true }"
                    x-show="show"
                    x-transition
                    x-init="setTimeout(() => show = false, 2000)"
                    class="text-sm text-gray-600 dark:text-gray-400"
                >{{ __('Saved.') }}</p>
            @endif
        </div>
    </form>
</section>
