<section>
    <header>
        <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
            {{ __('List Pengguuna') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
            {{ __("Kelola Daftar Pengguna") }}
        </p>
    </header>
    <div class="container mx-auto mt-6">
        <x-table :headers="['No','Nama','Email', 'Aksi']">
            @foreach ($users as $item)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900">{{ $loop->iteration }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium text-gray-900">{{ $item->name }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium text-gray-900">{{ $item->email }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-left text-sm font-medium">
                        <button onclick="editKelas('{{ $item->id }}', '{{ $item->name }}', '{{ $item->email}}', '{{ $item->role }}', '{{ $item->password}}')" class="text-indigo-600 hover:text-indigo-900">Edit</button>
                        <form action="{{ route('kelas.destroy', $item->id) }}" method="post" class="inline-block">
                            @csrf
                            @method('delete')
                            <button type="submit" onclick="return confirm('Apakah yakin ingin dihapus?')" class="text-red-600 hover:text-red-900">Delete</button>
                        </form>
                    </td>
                    </td>
                </tr>
            @endforeach
        </x-table>
    </div>
</section>

<script>
    function editKelas(id, name, email, role, password) {
        document.getElementById('pengguna-id').value = id;
        document.getElementById('name').value = name;
        document.getElementById('email').value = email;
        document.getElementById('role').value = role;
        document.getElementById('password').value = password;
        document.getElementById('form-title').innerText = 'Edit Pengguna';
        document.getElementById('form-button').innerText = 'Perbarui';

        document.getElementById('pengguna-form').action = '{{ route('pengguna.update', '') }}' + '/' + id;
        let methodInput = document.createElement('input');
        methodInput.setAttribute('type', 'hidden');
        methodInput.setAttribute('name', '_method');
        methodInput.setAttribute('value', 'PATCH');
        document.getElementById('pengguna-form').appendChild(methodInput);

    }
</script>
