<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PendaftaranController;
use App\Http\Controllers\KelasController;
use App\Http\Controllers\GuruController;
use App\Http\Controllers\InformasiController;
use App\Http\Controllers\PenggunaController;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth', 'checkRole:admin')->group(function () {
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::resource('kelas', KelasController::class)->names('kelas');
    Route::resource('pendaftaran', PendaftaranController::class)->names('pendaftaran')->except('index');
    Route::get('/pendaftaran-all', [PendaftaranController::class, 'allData'])->name('pendaftaran.all');

    Route::resource('guru', GuruController::class)->names('guru');
    Route::resource('informasi', InformasiController::class)->names('informasi')->except('show');
    Route::resource('pengguna', PenggunaController::class)->names('pengguna');
});

Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit')->middleware('auth');
Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update')->middleware('auth');
Route::resource('pendaftaran', PendaftaranController::class)->names('pendaftaran')->except('allData')->middleware('auth');
Route::get('/pendaftaran', [PendaftaranController::class, 'index'])->name('pendaftaran.index')->middleware('auth');

Route::get('/informasi/{informasi:slug}', [InformasiController::class, 'show'])->name('informasis.show');
Route::get('/informasis', [InformasiController::class, 'frontIndex'])->name('informasis.frontIndex');
Route::get('/gurus', [GuruController::class, 'frontIndex'])->name('gurus.frontIndex');

require __DIR__.'/auth.php';
